const gulp = require('gulp');
const sass = require('gulp-sass')(require('sass'));
const cleanCSS = require('gulp-clean-css');
const uglify = require('gulp-uglify');
const concat = require('gulp-concat');
const browserSync = require('browser-sync').create();
const postcss = require('gulp-postcss');
const autoprefixer = require('autoprefixer');
const path = require('path'); 


// Détection du nom du dossier courant
const projectFolderName = path.basename(__dirname);
const browserSyncProxy = `${projectFolderName}.locale`

// Chemins
const paths = {
  styles: {
    src: 'src/scss/main.scss',
    dest: 'css'
  },
  scripts: {
    src: 'src/js/**/*.js',
    dest: 'js'
  },
  php: {
    src: './**/*.php'
  }
};

// Sass → CSS minifié
function styles() {
 return gulp.src(paths.styles.src)
    .pipe(sass().on('error', sass.logError))
    .pipe(postcss([autoprefixer()]))
    .pipe(cleanCSS())
    .pipe(gulp.dest(paths.styles.dest))
    .pipe(browserSync.stream());
}

// JS → concaténé + minifié
function scripts() {
  return gulp.src(paths.scripts.src)
    .pipe(concat('main.js'))
    .pipe(uglify())
    .pipe(gulp.dest(paths.scripts.dest))
    .pipe(browserSync.stream());
}

// Lancer BrowserSync et surveiller les fichiers
function serve() {
  browserSync.init({
    proxy: browserSyncProxy,
    open: true,
    notify: false
  });

  gulp.watch('src/scss/**/*.scss', styles);
  gulp.watch(paths.scripts.src, scripts);
  gulp.watch(paths.php.src).on('change', browserSync.reload);
}

// Tâches par défaut
exports.default = gulp.series(
  gulp.parallel(styles, scripts),
  serve
);