<?php define('ROOT', $_SERVER['DOCUMENT_ROOT']. '/'); ?>
<!doctype html>
<html lang="fr">
<head>
    <meta charset="utf-8">
    <title></title>
    <meta name="description" content="">
    <meta property="og:title" content="">
    <meta property="og:description" content="">
    <meta property="og:url" content="">
    <link rel="canonical" href="">
    <link rel="preload" fetchpriority="high" as="image" href="/images/webp/index/.webp" type="image/webp" media="(min-width:1024px)">
    <link rel="preload" fetchpriority="high" as="image" href="/images/webp/index/-mb.webp" type="image/webp" media="(max-width:1023px)">
    <?php include(ROOT."inc/meta.php"); ?>
</head>

<body>

    <?php include(ROOT."inc/header.php"); ?>

    <main id="index">
        <section class="section-intro">
            <div class="container-90">
                <picture>
                    <source media="(min-width:1024px)" srcset="/images/webp/index/deneigement.webp" type="image/webp">
                    <source media="(min-width:1024px)" srcset="/images/index/deneigement.jpg">
                    <source srcset="/images/webp/index/deneigement-mb.webp" type="image/webp">
                    <img src="/images/index/deneigement-mb.jpg" class="background" width="" height="" alt="" fetchpriority="high">
                </picture>
            </div>
        </section>

        <section class="section-description">
            <div class="container-full">dsadasd</div>
        </section>

        <section class="section-qualites">
            <div class="banner">
                <picture>
                    <img src="/images/construction-interieur.jpg" class="background" width="" height="" loading="lazy">
                </picture>
                <div class="banner-content">
                    dsads
                </div>
            </div>
        </section>

        <section>
            <div style="--delay: 0.2s;"></div>
            <div style="--delay: 0.4s;"></div>
            <div style="--delay: 0.6s;"></div>
            <div style="--delay: 0.8s;"></div>
        </section>

        <!-- Délai dynamiquement -->
        <?php foreach($modeles as $key => $modele) { ?>
            <div class="anim-opacity" style="--delay:0.<?= $key + 2 ?>s">
                <picture>
                    <source srcset="/images/webp/index/<?= pathinfo($modele['index']['img'], PATHINFO_FILENAME) ?>.webp" type="image/webp">
                    <img src="/images/index/<?= $modele['index']['img'] ?>" width="200" height="200" alt="<?= $modele['index']['alt'] ?>" loading="lazy">
                </picture>
            </div>
        <?php } ?>

    </main>

    <?php include(ROOT."inc/footer.php"); ?>


</body>
</html>