document.addEventListener("DOMContentLoaded", () => {
    const items = [
        {
            heading: "Essentiels",
            text: "Les témoins essentiels au fonctionnement du site Web pour livrer le service que vous avez demandé. Ces témoins ne peuvent pas être désactivés et ne stockent aucune donnée personnellement identifiable.",
            defaultValue: true,
            locked: true,
        },
        {
            heading: "Analytiques",
            text: "Les témoins analytiques nous aident à comprendre comment les visiteurs interagissent avec le site Web. Ces témoins nous informent sur le nombre de visiteurs, le taux de rebond, la source de trafic, le temps d’utilisation, etc.",
            defaultValue: false,
            locked: false,
        },
        {
            heading: "Publicités",
            text: "Les témoins de publicité sont utilisés pour diffuser aux visiteurs des publicités personnalisées basées sur les pages visitées auparavant et analyser l'efficacité de la campagne de publicité.",
            defaultValue: false,
            locked: false,
        },
    ];

    const consentMode = localStorage.getItem("consentMode");

    if (consentMode === null || consentMode === undefined) {
        document.getElementById("cookies-consent-banner").style.display = "block";
    }
    createList(items);
    initializeButtonsAndModal();
});

function openModal() {

    const modal = document.getElementById("cookies-configuration-modal");
    modal.style.display = "flex";

    modal.classList.remove("cookies-modal-animate-close");
    modal.classList.remove("cookies-modal-animate-open");

    requestAnimationFrame(() => {
        modal.classList.add("cookies-modal-animate-open");
    });

    if (localStorage.getItem("consentMode")) {
        const consentData = JSON.parse(localStorage.getItem("consentMode"));
        const item1Element = document.getElementById("item1");
        const item2Element = document.getElementById("item2");
        if (consentData.analytics_storage=='granted') {
            item1Element.checked = true;
        }
        if (consentData.ad_storage=='granted') {
            item2Element.checked = true;
        }
    }
}

function closeModal() {
    const modal = document.getElementById("cookies-configuration-modal");
    modal.classList.remove("cookies-modal-animate-open");
    modal.classList.add("cookies-modal-animate-close");

    function removeClass(e) {
        if (e.propertyName === "opacity") {
            modal.classList.remove("cookies-modal-animate-close");
            modal.style.display = "none";
            modal.removeEventListener("transitionend", removeClass);
        }
    }

    modal.addEventListener("transitionend", removeClass);
}

function createList(items) {
    const list = document.getElementById("cookies-modal-configuration-list");
    items.forEach((item, index) => {
        const listItem = document.createElement("li");
        listItem.classList.add("cookies-modal-list-item");

        const divContainer = document.createElement("div");
        divContainer.classList.add("cookies-toggle-container");

        const heading = document.createElement("span");
        heading.appendChild(document.createTextNode(item.heading));
        heading.classList.add("cookies-toggle-heading");

        const checkbox = document.createElement("input");
        checkbox.type = "checkbox";
        checkbox.id = "item" + index;
        checkbox.classList.add("cookies-toggle-checkbox");
        checkbox.checked = item.defaultValue;
        checkbox.disabled = item.locked;

        const label = document.createElement("label");
        label.htmlFor = "item" + index;
        label.classList.add("cookies-toggle-label");

        const text = document.createElement("span");
        text.appendChild(document.createTextNode(item.text));
        text.classList.add("cookies-toggle-text");

        divContainer.appendChild(heading);
        divContainer.appendChild(text);
        listItem.appendChild(divContainer);
        listItem.appendChild(checkbox);
        listItem.appendChild(label);
        list.appendChild(listItem);
    });
}

//--------------------------------------------------------------------------------------------------
//---------------------------Section pour les tag de consentement Google----------------------------
//--------------------------------------------------------------------------------------------------

function initializeButtonsAndModal() {
    document.getElementById("cookies-modal-close-button").addEventListener("click", closeModal);
    document.getElementById("cookies-modal-backdrop").addEventListener("click", closeModal);
    document.getElementById("cookies-accept-button").addEventListener("click", acceptCookies);
    document.getElementById("cookies-configuration-button").addEventListener("click", openModal);
    document.getElementById("cookies-configuration-link").addEventListener("click", openModal);
    document.getElementById("cookies-decline-button").addEventListener("click", declineCookies);
    document.getElementById("cookies-modal-save-button").addEventListener("click", configurationPersonnelCookies);
}

function hideCookieBanner() {
    document.getElementById("cookies-consent-banner").classList.add("cookies-banner-close");
}

function updateConsent(adConsent, analyticsConsent, adPersonalizationConsent, adUserDataConsent, functionalityStorage, securityStorage, PersonalizationStorage) {
    const consentData = {
        ad_storage: adConsent ? "granted" : "denied",
        analytics_storage: analyticsConsent ? "granted" : "denied",
        ad_personalization: adPersonalizationConsent ? "granted" : "denied",
        ad_user_data: adUserDataConsent ? "granted" : "denied",
        functionality_storage: "granted",
        security_storage: "granted",
        personalization_storage:  PersonalizationStorage ? "granted" : "denied",
    };

    localStorage.setItem("consentMode", JSON.stringify(consentData));
    gtag("consent", "update", consentData);
}

function configurationPersonnelCookies() {
    const analyticsChecked = document.getElementById("item1").checked;
    const adsChecked = document.getElementById("item2").checked;

    updateConsent(adsChecked, analyticsChecked, adsChecked, adsChecked, true, true, true );
    closeModal();
    hideCookieBanner();
}

function acceptCookies() {
    updateConsent(true, true, true, true, true, true, true);
    window.dataLayer.push({ event: "consent_granted" });
    closeModal();
    hideCookieBanner();
}

function declineCookies() {
    updateConsent(false, false, false, false, false, false, false);
    closeModal();
    hideCookieBanner();
}